<?php
//Advanced Login System Language File
//English
//Created by Wu Xiao Tian 19/9/07
//Updated 5/12/07
//Updated again 1/6/08
//Updated on 29/9/08 for reset definitions
//Updated on 18/11/08 to make full use of constants
//v0.03.3
//Meant for ALS v0.03B Build 20081118 and above

//Version check for the language file
$requiredver = "20081127";

//This language file is the default langauge file included with all Advanced Login System v0.03B and above
//You can create your own language file by following this template.
//The template for creating language files is named alslanguages/alslang-template.php
//note that some values are shared across multiple files
//read the readme.html file in the docs folder for more information on creating language files



//define text - Login Form
//I am making use of constants here, to prevent any conflicting variable numbers.
define ("LOGINTITLE","Login");
define ("LOGINHEADER","Login");
define ("LOGINTEXT","Please login below to access our resources.");
define ("USERNAME","Username"); //username field
define ("PASSWORD","Password"); //password field
define ("IMGVALIDATION","Enter the number below"); //Instruction for image validation
define ("REFRESHMSG","%refresh% if you cannot see the number"); //unable to view number message. Note: place the word that you want to link to the refresh function within 2 percentage signs. Eg. %refresh% here
define ("RMBPASS","Remember Pass?"); //Remember Password message
define ("SECURITYMSG","You are strongly advised against remembering the password on shared computers."); //displayed in an alert
define ("LOGINBUT","Login"); //Value of Login button
define ("REGLINK","Register"); //User registration link
define ("RSTLINK","Forgot Password?"); //reclaim password link

//define text - login.php logout messages
define ("SESSIONEXPIRE", "Your session has expired.");
define ("LOGOUT","You are logged out. Thank you for using Advanced Login System."); //message to display when user is logged out
define ("CONT","Continue"); //text for continue

//error messages
define ("CAPTCHAEXPIRE","The CAPTCHA number has expired. Please try again.");
define ("WRONGIMG","The CAPTCHA number you entered does not match the one generated by the server."); //error message for wrong CAPTCHA number 
define ("TRIESLEFT"," trie(s) left."); //tries left
define ("WRONGACCT","Invalid username and password combination or non-activated account."); //wrong username and password
define ("EXCEEDTRIES","You have exceeded your number of tries in the last 15 minutes. Please wait 15 minutes before trying again");
define ("RETRY","Retry?");

//define text - registration form - a number of fields are shared with the login form.
define ("REGISTERTITLE","Register");
define ("REGISTERHEADER","New User");
define ("REGISTERTEXT","Fill in the form below to create a new account.");
define ("MINPASSMSG","(min %MINPASSLEN% characters)");
define ("CONPASS","Confirm Password");
define ("EMAIL","Email");
define ("REGISTERBUT", "Register");
define ("EXITBUT","Go Back");

//define text - manual activation
define ("ACTTITLE","Activate Account");
define ("ACTHEADER", "Activate Your Account");
define ("ACTMSG","Fill in the following fields with the information from your email to activate your account");
define ("ACTKEY","Activation Key");
define ("ACTBUT","Activate");

//define text - register.php messages
define ("NOACTIVATE","Unable to activate your account. Please check that you have provided the correct details.");
define ("ACTIVATEDONE","Your account has been activated. You can now login.");
define ("PASSTOOSHORT","The password you entered is too short. It needs to be at least %MINPASSLEN% characters long.");
define ("TAKENUSER","Sorry, but that username is already taken.");
define ("NOUSERNAME","You need to fill up the username field.");
define ("CONPASSNPASS","You need to fill up the password and confirm password fields.");
define ("NOEMAIL","You need to fill in your email address.");
define ("EMAILINDB","Your email address already exists on the database! If you have forgotten your password,you can reset it by clicking <a href=\"reset.php\">here</a>.");
define ("INVALEMAIL","You did not enter a valid email address.");
define ("PASSNOMATCH","Your passwords doesn't match.");
define ("REGISTEROKREQEMAIL","You are registered! An activation email has been sent to your email address. You need to activate your account before you can login.");
define ("REGISTEROK","You are registered! You can login now.");
define ("REGISTERMAILPROB","There is a problem with the mail server. Click on the link below to activate your account.");
define ("EMAILTITLE","Your Activation Key");
define ("EMAILMSG","Thank you for registering with Advanced Login System.\n\nPaste the URL below to activate your account at Advanced Login System.\n%ACTIVATIONURL%\n\n Alternatively, you can activate your account manually at %SCRIPTURL% and entering %ACTIVATIONKEY% as your Activation key.");

//define text - closed registration
define ("NOREGISTERMSG","The admin has disabled user registration. If you are the admin,you can login below to create a new user by entering your MySQL database username and MySQL database password.");
define ("ADMINLOGINHEADER","Admin Login");
define ("ADMINLOGOUT","Log out of Admin Account");
define ("ADMINLOGGEDOUT","You have been logged out of your admin account");

//define text - reset form
define ("RESETTITLE","Reset Password");
define ("RESETHEADER","Reset Password");
define ("PINENTERTITLE", "Enter your reset PIN");
define ("ENTERPIN", "Click here to enter your PIN.");
define ("RESETTEXT", "Enter your username and email to recieve a PIN to reset your account password.");
define ("RESETBUT", "Send PIN");
define ("PINSENT", "You have been sent a PIN via email. Enter the PIN below to set your new password.");
define ("RESETPASSBUT", "Reset Password");

//define text- reset.php messages
define ("WRONGRESET", "Invalid username and email combination");
define ("PINMAILPROB", "There is a problem with the mail server. For security reasons, your PIN will not be revealed here. Please contact ".$admin_email." for your PIN.");
define ("WRONGPIN","You did not enter a correct PIN");
define ("RESETEMAILTITLE", "Your Reset PIN");
define ("RESETEMAIL", "You have requested a PIN to reset your password to your account. \n Your PIN is %pin%.\nEnter this PIN to reset your password. \n If you did not request for this PIN, please ignore this message."); //Use %pin% to place the PIN value in the email.
define ("RESETPASSNOMATCH","The new passwords entered do not match.");
define ("PASSRESET","Your password has been reset.");

//define text - changepass form
define ("CHANGEPASSTITLE", "Change Password");
define ("CHANGEPASSHEADER", "Change Password");
define ("CHANGEPASSTEXT","Enter your current password below to change it.");
define ("CURRENTPASS","Current Password");
define ("NEWPASS","New Password");
define ("CONNEWPASS","Confirm New Password");
define ("CHANGEPASSBUT","Change Password");

//define text - changepass.php messages
define ("NOCURRENTPASS","You need to enter your current password.");
define ("NONEWPASS","You need to enter a new password.");
define ("NEWPASSNOMATCH","The new passwords entered do not match.");
define ("WRONGOLDPASS", "You did not enter your current password correctly.");
define ("PASSCHANGED","Your password has been changed! Please login again.");
?>